<?php

namespace App\Messenger\Handler;

use App\Messenger\Message\SendMessage;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Mime\Email;

#[AsMessageHandler]
class MessageHandler
{
    public function __construct(
        protected MessageBusInterface $bus,
        private MailerInterface $mailer
    )
    {
    }

    /**
     * Обработка письма из очереди
     *
     * @param SendMessage $message
     *
     * @return void
     * @throws TransportExceptionInterface
     */
    public function __invoke(SendMessage $message): void
    {
        switch ($message->getSendType()) {
            case 'EMAIL':
                $mail = new Email();
                $mail
                    ->subject($message->getSubject())
                    ->from($message->getFrom())
                    ->to($message->getTo())
                    ->html($message->getBody());
                try {
                    $this->mailer->send($mail);
                } catch (\Exception $exception) {
                    throw new \Exception('Ошибка отправки письма');
                }
                break;
            case 'SMS':
                throw new \Exception('Отправка СМС недоступна');
                break;
        }
    }
}