<?php

namespace App\Listeners;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\ExceptionEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;

class AccessDeniedListener implements EventSubscriberInterface
{

    public static function getSubscribedEvents(): array
    {
        return [
            KernelEvents::EXCEPTION => ['onAccessException', 2],
        ];
    }

    public function onAccessException(ExceptionEvent $event): void
    {
        $response = new \App\Service\Response\Classes\Response();
        $response->setStatusCode(Response::HTTP_FORBIDDEN);
        $response->addError('Доступ запрещен');

        $exception = $event->getThrowable();
        if (!$exception instanceof AccessDeniedException) {
            return;
        }
        $event->setResponse($response->getResponse());
    }
}