<?php

namespace App\Controller;

use App\Service\Action\ActionServiceInterface;
use App\Service\Dto\Classes\ChangeProfileDto;
use App\Service\Dto\Classes\ImageDto;
use App\Service\Dto\Classes\RecoveryCodeDto;
use App\Service\Dto\Classes\RecoveryDto;
use App\Service\Response\Classes\FavoritesResponse;
use App\Service\Response\Classes\ProfileResponse;
use App\Service\Response\Classes\QuestsResponse;
use App\Service\Response\Classes\Response;
use App\Service\Response\Classes\ReviewsResponse;
use Nelmio\ApiDocBundle\Annotation\Model;
use Nelmio\ApiDocBundle\Annotation\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_')]
#[OA\Tag(name: 'Профиль')]
class ProfileController extends AbstractController
{
    #[Route('/profile', name: 'profile', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: ProfileResponse::class, groups: ["message", "data", "profile"])
        )
    )]
    public function profile(
        #[Autowire(service: 'action.profile')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/favorites', name: 'favorites', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: FavoritesResponse::class, groups: ["message", "data", "card"])
        )
    )]
    public function favorites(
        #[Autowire(service: 'action.favorites')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/reviews', name: 'reviews', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: ReviewsResponse::class, groups: ["message", "data", "card"])
        )
    )]
    public function reviews(
        #[Autowire(service: 'action.reviews')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/quests', name: 'profile_quests', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: QuestsResponse::class, groups: ["message", "data", "card"])
        )
    )]
    public function quests(
        #[Autowire(service: 'action.profile.quests')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/delete', name: 'profile_delete', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function deleteProfile(
        #[Autowire(service: 'action.profile.delete')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/recovery', name: 'profile_recovery', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: RecoveryDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    #[Security(name: null)]
    public function recoveryProfile(
        #[Autowire(service: 'action.recovery.send')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/recovery/check', name: 'profile_recovery_check', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: RecoveryCodeDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    #[Security(name: null)]
    public function recoveryCodeProfile(
        #[Autowire(service: 'action.recovery.code')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/change', name: 'profile_change', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: ChangeProfileDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: ProfileResponse::class, groups: ["message", "data", "profile"])
        )
    )]
    public function changeProfile(
        #[Autowire(service: 'action.profile.change')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/email/reset', name: 'profile_email_reset', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function resetLastConfirmEmail(
        #[Autowire(service: 'action.reset.email')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/image', name: 'profile_image', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: ImageDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function saveImage(
        #[Autowire(service: 'action.profile.image.save')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/profile/image/delete', name: 'profile_image_delete', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function deleteImage(
        #[Autowire(service: 'action.profile.image.delete')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }
}
