<?php

namespace App\Validators;

use Symfony\Component\Validator\Context\ExecutionContextInterface;

class UserValidator
{
    /**
     * Проверка на наличие номера телефона либо email
     *
     * @param mixed $value
     * @param ExecutionContextInterface $context
     * @param mixed $payload
     *
     * @return void
     */
    public static function validateEmailOrPhone(mixed $value, ExecutionContextInterface $context, mixed $payload): void
    {
        $oObject = $context->getObject();
        if ($oObject) {
            if ($oObject->email !== null && $oObject->phoneNumber !== null) {
                $context->buildViolation('Передайте либо Email либо номер телефона')
                    ->addViolation();
            }
        }
    }
}