<?php

namespace App\Service\Action\Classes;

use App\Entity\Appointment;
use App\Entity\Quest;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quest.subscribe', public: true)]
class SubscribeQuest extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.id')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var IdDto $dto */
        $dto = $this->getDto();
        if ($dto->id && $this->user->getId()) {
            /** @var Quest|null $quest */
            $quest = $this->doctrine->getRepository(Quest::class)->findOneById($dto->id, $this->user->getId(), false);
            if ($quest) {
                if ($quest->getAppointmentCount() >= $quest->getMaxAppointments()) {
                    $this->responseService->addError('Максимальное количество участников');
                } elseif (new \DateTime() > $quest->getFinalDate()) {
                    $this->responseService->addError('Время записи на квест окончено, записаться нельзя');
                } else {
                    $appointments = $quest->getAppointments();
                    $exists = false;
                    foreach ($appointments as $appointment) {
                        if ($appointment->getRelatedUser() === $this->user) {
                            $exists = true;
                        }
                    }
                    if (!$exists) {
                        try {
                            $newAppointment = new Appointment();
                            $newAppointment->setQuest($quest);
                            $newAppointment->setRelatedUser($this->user);
                            $em = $this->doctrine->getManager();
                            $em->persist($newAppointment);
                            $em->flush();
                            $this->responseService->addMessage('Вы записаны на квест');
                        } catch (\Exception $exception) {
                            $this->responseService->addError('Ошибка записи на квест');
                        }
                    } else {
                        $this->responseService->addError('Вы уже записаны');
                    }
                }
            } else {
                $this->responseService->addError('Квест не найден');
            }
        } else {
            $this->responseService->addError('Не получен Id');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}