<?php

namespace App\Service\Action\Classes;

use App\Service\Action\UserBaseActionService;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;

#[AsAlias(id: 'action.profile.delete', public: true)]
class DeleteProfile extends UserBaseActionService
{
    /**
     * Деактивация учетной записи
     *
     * @return void
     */
    public function runAction(): void
    {
        try {
            $this->user->setDeleted(true);
            $em = $this->doctrine->getManager();
            $em->persist($this->user);
            $em->flush();
            $this->responseService->addMessage('Профиль удален');
        } catch (\Exception $exception) {
            $this->responseService->addError('Ошибка удаления профиля');
        }
    }

    public function needDto(): bool
    {
        return false;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}