<?php

namespace App\Controller;

use App\Service\Action\ActionServiceInterface;
use App\Service\Dto\Classes\ChangePasswordDto;
use App\Service\Dto\Classes\LoginDto;
use App\Service\Dto\Classes\RecoveryDto;
use App\Service\Dto\Classes\RegisterCodeDto;
use App\Service\Dto\Classes\RegisterDto;
use App\Service\Dto\Classes\ResetPasswordCodeDto;
use App\Service\Response\Classes\Response;
use App\Service\Response\Classes\TokenResponse;
use Nelmio\ApiDocBundle\Annotation\Model;
use Nelmio\ApiDocBundle\Annotation\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_')]
#[OA\Tag(name: 'Авторизация')]
class AuthController extends AbstractController
{
    #[Route('/register', name: 'register', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: RegisterDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    #[Security(name: null)]
    public function register(
        #[Autowire(service: 'action.register')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/email/send', name: 'email_send', methods: ['GET'])]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function sendRegisterCode(
        #[Autowire(service: 'action.register.send')]
        ActionServiceInterface $actionService,
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/email/check', name: 'email_check', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: RegisterCodeDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function checkRegisterCode(
        #[Autowire(service: 'action.register.code')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/password/reset', name: 'password_reset', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: ChangePasswordDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    public function resetPassword(
        #[Autowire(service: 'action.reset.password.change')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/password/send', name: 'password_send', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: RecoveryDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    #[Security(name: null)]
    public function sendResetPassword(
        #[Autowire(service: 'action.reset.password.send')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }

    #[Route('/password/reset/check', name: 'password_reset_check', methods: ['POST'])]
    #[OA\RequestBody(
        content: new OA\JsonContent(ref: new Model(type: ResetPasswordCodeDto::class))
    )]
    #[OA\Response(
        response: 200,
        description: 'Ответ',
        content: new OA\JsonContent(
            ref: new Model(type: Response::class, groups: ["message"])
        )
    )]
    #[Security(name: null)]
    public function resetCheckPassword(
        #[Autowire(service: 'action.reset.password.code')]
        ActionServiceInterface $actionService
    ): JsonResponse
    {
        return $actionService->getResponse();
    }
}
