<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Validator\Constraints as Assert;

#[AsAlias(id: 'dto.review.create', public: true)]
class CreateReviewDto extends BaseDto
{
    #[Assert\NotBlank(
        message: 'Не получен текст отзыва.',
    )]
    public ?string $text = null;

    #[Assert\Range(
        notInRangeMessage: 'Оценку можно поставить от {{ min }} до {{ max }}.',
        min: 0,
        max: 10,
    )]
    public ?int $rating = null;

    #[Assert\NotBlank(
        message: 'Не передан Id квеста.',
    )]
    public ?int $questId = null;
}