<?php

namespace App\Service\Action\Classes;

use App\Service\Action\UserBaseActionService;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;

#[AsAlias(id: 'action.reset.email', public: true)]
class ResetEmail extends UserBaseActionService
{
    public function runAction(): void
    {
        if ($email = $this->user->getLastConfirmEmail()) {
            if ($email === $this->user->getEmail()) {
                $this->responseService->addMessage('Подтвержденный email уже установлен');
            } else {
                try {
                    $this->user->setEmail($email);
                    $em = $this->doctrine->getManager();
                    $em->persist($this->user);
                    $em->flush();
                    $this->responseService->addMessage('Установлен email: ' . $email);
                } catch (\Exception $e) {
                    $this->responseService->addError('Ошибка сохранения email');
                }
            }
        } else {
            $this->responseService->addError('Нет последнего подтвержденного email');
        }
    }

    public function needDto(): bool
    {
        return false;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}