<?php

namespace App\Service\Action\Classes;

use App\Entity\Quest;
use App\Entity\Review;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\CreateReviewDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quest.review.create', public: true)]
class CreateReview extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.review.create')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var CreateReviewDto $dto */
        $dto = $this->getDto();
        if ($dto->questId && $this->user->getId()) {
            /** @var Quest|null $quest */
            $quest = $this->doctrine->getRepository(Quest::class)->findOneById($dto->questId, $this->user->getId());
            if ($quest) {
                $reviews = $quest->getReviews();
                $exists = null;
                foreach ($reviews as $review) {
                    if ($review->getRelatedUser() === $this->user) {
                        $exists = $review;
                    }
                }
                if ($exists) {
                    $this->responseService->addError('Ваш отзыв на квест уже существует');
                } else {
                    try {
                        $newReview = new Review();
                        $newReview->setRelatedUser($this->user);
                        $newReview->setQuest($quest);
                        $newReview->setText($dto->text);
                        $newReview->setRating($dto->rating);
                        $em = $this->doctrine->getManager();
                        $em->persist($newReview);
                        $em->flush();
                        $this->responseService->addMessage('Отзыв добавлен');
                    } catch (\Exception $exception) {
                        $this->responseService->addError('Ошибка сохранения отзыва');
                    }
                }
            }
        } else {
            $this->responseService->addError('Не передан ID квеста');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}