<?php

namespace App\Redis;

use Exception;
use Psr\Cache\InvalidArgumentException;
use Symfony\Component\Cache\Adapter\RedisAdapter;

class Redis
{
    private static self $instance;

    private RedisAdapter $cache;

    /**
     * @throws Exception
     */
    private function __construct()
    {
        $client = RedisAdapter::createConnection('redis://redis');
        $client->connect('127.0.0.1', $_ENV['REDIS_PORT']);
        if ($client->isConnected()) {
            $this->cache = new RedisAdapter($client);
        } else {
            throw new \RuntimeException('Redis не подключен');
        }
    }

    public static function getInstance(): Redis
    {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Запись значения
     *
     * @param string $key
     * @param mixed $value
     *
     * @return $this
     * @throws InvalidArgumentException
     */
    public function set(string $key, mixed $value): self
    {
        $item = $this->cache->getItem($key);
        $item->set($value);
        $this->cache->save($item);

        return $this;
    }

    /**
     * @param string $key
     *
     * @return mixed
     * @throws InvalidArgumentException
     */
    public function get(string $key): mixed
    {
        return $this->cache->getItem($key)->get();
    }

    public function delete(string $key): self
    {
        $this->cache->deleteItem($key);

        return $this;
    }

    public function has(string $key): bool
    {
        return $this->cache->hasItem($key);
    }
}