<?php

namespace App\Messenger\Handler;

use App\Messenger\Message\QuestMessage;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Mime\Email;

#[AsMessageHandler]
class QuestMessageHandler
{
    public function __construct(
        protected MessageBusInterface $bus,
        private MailerInterface $mailer
    )
    {
    }

    /**
     * Обработка письма из очереди
     *
     * @param QuestMessage $message
     *
     * @return void
     * @throws TransportExceptionInterface
     */
    public function __invoke(QuestMessage $message): void
    {
        $mail = new Email();
        $mail
            ->subject($message->getSubject())
            ->from($message->getFrom())
            ->to($message->getTo())
            ->html($message->getBody());
        try {
            $this->mailer->send($mail);
        } catch (\Exception $exception) {
            throw new \Exception('Ошибка отправки письма');
        }
    }
}