<?php

namespace App\Listeners;

use App\Entity\UserImage;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Events;
use Symfony\Component\Filesystem\Filesystem;

#[AsEntityListener(event: Events::preFlush, method: 'prePersist', entity: UserImage::class)]
#[AsEntityListener(event: Events::preUpdate, method: 'preUpdate', entity: UserImage::class)]
#[AsEntityListener(event: Events::postRemove, method: 'postRemove', entity: UserImage::class)]
class UserImageListener
{
    public function prePersist(UserImage $file, PreFlushEventArgs $args): void
    {
        $om = $args->getObjectManager();
        if (!$this->checkFile($file)) {
            $om->remove($file);
            $om->flush();
        }
    }

    public function preUpdate(UserImage $file, PreUpdateEventArgs $args): void
    {
        $om = $args->getObjectManager();
        if (!$this->checkFile($file)) {
            $om->remove($file);
            $om->flush();
        }
    }

    public function postRemove(UserImage $file, PostRemoveEventArgs $args): void
    {
        $om = $args->getObjectManager();
        $this->removeFile($file);
    }

    /**
     * Проверка наличия файла
     *
     * @param UserImage $file
     *
     * @return bool
     */
    private function checkFile(UserImage $file): bool
    {
        if ($path = $file->getPath()) {
            $filesystem = new Filesystem();
            if ($filesystem->exists([$path])) {
                return true;
            }
        }

        return false;
    }

    /**
     * Удаление файла
     *
     * @param UserImage $file
     *
     * @return void
     */
    private function removeFile(UserImage $file): void
    {
        if ($path = $file->getPath()) {
            $filesystem = new Filesystem();
            if ($filesystem->exists([$path])) {
                $filesystem->remove([$path]);
            }
        }
    }
}