<?php

namespace App\Service\Response\Classes;

use App\Entity\User;
use Symfony\Component\Serializer\Annotation\Groups;

class ProfileResponse extends Response
{
    /**
     * @var User|null
     */
    #[Groups(["data"])]
    public ?User $data = null;

    public function setData(User $user): self
    {
        $this->data = $user;

        return $this;
    }

    public function getGroups(): array
    {
        return ['profile'];
    }
}