<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use App\Validators\UserValidator;
use Symfony\Component\Validator\Constraints as Assert;

#[Assert\Callback([UserValidator::class, 'validateEmailOrPhone'])]
class RecoveryDto extends BaseDto
{
    #[Assert\Email(
        message: 'Email "{{ value }}" неверный.',
    )]
    public ?string $email = null;

    #[Assert\Regex(
        pattern: '/^((8|\+7)[\- ]?)?(\(?\d{3}\)?[\- ]?)?[\d\- ]{7,10}$/i',
        message: 'Неверный формат телефона'
    )]
    public ?string $phoneNumber = null;
}