<?php

namespace App\Service\Action\Classes;

use App\Entity\User;
use App\Service\Action\BaseActionService;
use App\Service\Dto\Classes\RecoveryCodeDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.recovery.code', public: true)]
class CheckRecoveryCode extends BaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.recovery.code')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }


    /**
     * Восстановление учетной записи по коду
     *
     * @return void
     */
    public function runAction(): void
    {
        /** @var RecoveryCodeDto $dto */
        $dto = $this->getDto();
        /** @var User $userExists */
        $userExists = $this->doctrine->getRepository(User::class)
            ->findOneByUniq($dto->email, $dto->phoneNumber);

        if ($userExists) {
            $currentDate = new \DateTime();
            $code = $dto->code;
            $registerCode = $userExists->getRegisterCode();
            if ($registerCode === null) {
                $this->responseService->addError('Код подтверждения не отправлен');
            } else {
                if ($registerCodeDate = $registerCode->getDate()) {
                    if ($registerCode->getCode() === $code && $currentDate->getTimestamp() < $registerCodeDate->getTimestamp()) {
                        try {
                            $userExists->setDeleted(false);
                            $em = $this->doctrine->getManager();
                            $em->persist($userExists);
                            $em->remove($registerCode);
                            $em->flush();
                            $this->responseService->addMessage('Профиль восстановлен');
                        } catch (\Exception $exception) {
                            $this->responseService->addError('Ошибка восстановления профиля');
                        }
                    } else {
                        $this->responseService->addError('Код недействителен');
                    }
                } else {
                    $this->responseService->addError('Код недействителен');
                }
            }
        } else {
            $this->responseService->addError('Пользователь не найден');
        }
    }

    public function needDto(): bool
    {
        return true;
    }
}