<?php

namespace App\Service\Response\Classes;

use App\Entity\Review;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.reviews', public: true)]
class ReviewsResponse extends Response
{
    /**
     * @var Review[]
     */
    #[Groups(["data"])]
    public array $data;

    /**
     * @param Review[] $quest
     *
     * @return $this
     */
    public function setData(array $quest): self
    {
        $this->data = $quest;

        return $this;
    }

    public function getGroups(): array
    {
        return ['card'];
    }
}