<?php

namespace App\Service\Response\Classes;

use App\Entity\Quest;
use App\Service\Response\Classes\Data\Pagination;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.quests.page', public: true)]
class QuestsPagedResponse extends Response
{
    /**
     * @var Pagination
     */
    #[Groups(["data"])]
    public Pagination $data;

    /**
     * @param Quest[] $questList
     *
     * @return $this
     */
    public function setData(Pagination $questList): self
    {
        $this->data = $questList;

        return $this;
    }

    public function getGroups(): array
    {
        return ['card', 'pagination'];
    }
}