<?php

namespace App\Service\Response\Classes;

use App\Service\Dto\Classes\FilterDto;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.filter', public: true)]
class FilterResponse extends Response
{
    /**
     * @var FilterDto
     */
    #[Groups(["data"])]
    public FilterDto $data;

    /**
     * @param FilterDto $quest
     *
     * @return $this
     */
    public function setData(FilterDto $quest): self
    {
        $this->data = $quest;

        return $this;
    }

    public function getGroups(): array
    {
        return ['data'];
    }
}