<?php

namespace App\Service\Response\Classes;

use App\Entity\Favorite;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'response.favorites', public: true)]
class FavoritesResponse extends Response
{
    /**
     * @var Favorite[]
     */
    #[Groups(["data"])]
    public array $data;

    /**
     * @param Favorite[] $quest
     *
     * @return $this
     */
    public function setData(array $quest): self
    {
        $this->data = $quest;

        return $this;
    }

    public function getGroups(): array
    {
        return ['card'];
    }
}