<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Serializer\Annotation\Groups;

#[AsAlias(id: 'dto.filter', public: true)]
class FilterDto extends BaseDto
{
    /**
     * @var string|null
     */
    #[Groups(['data'])]
    public ?string $search;

    /**
     * @var string|null
     */
    #[Groups(['data'])]
    public ?string $sortField;

    /**
     * @var string|null
     */
    #[Groups(['data'])]
    public ?string $sort;

    /**
     * @var string[]
     */
    #[Groups(['data'])]
    public array $tags;

    /**
     * @var string[]
     */
    #[Groups(['data'])]
    public array $genres;

    /**
     * @var string[]
     */
    #[Groups(['data'])]
    public array $themes;
}