<?php

namespace App\Entity;

use App\Repository\UserImageRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: UserImageRepository::class)]
class UserImage
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\OneToOne(inversedBy: 'image', cascade: ['persist'])]
    private ?User $related_user = null;

    #[ORM\Column(length: 255)]
    private ?string $path = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $type = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getRelatedUser(): ?User
    {
        return $this->related_user;
    }

    public function setRelatedUser(?User $related_user): static
    {
        $this->related_user = $related_user;

        return $this;
    }

    #[Groups(['all', 'edit'])]
    public function getPath(): ?string
    {
        return $this->path;
    }

    #[Groups(['all', 'profile', 'edit'])]
    public function getPublicPath(): ?string
    {
        if ($this->path !== null) {
            return str_replace('/app/public', '', $this->path);
        }
        return null;
    }

    public function setPath(string $path): static
    {
        $this->path = $path;

        return $this;
    }

    #[Groups(['all', 'profile', 'edit'])]
    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    #[Groups(['all', 'edit'])]
    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): static
    {
        $this->type = $type;

        return $this;
    }
}
