<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use Symfony\Component\Validator\Constraints as Assert;

class ChangeProfileDto extends BaseDto
{
    #[Assert\Email(
        message: 'Email "{{ value }}" неверный.',
    )]
    public ?string $email = null;

    public ?string $name = null;

    public ?string $surname = null;

    public ?string $patronymic = null;

    #[Assert\Regex(
        pattern: '/^((8|\+7)[\- ]?)?(\(?\d{3}\)?[\- ]?)?[\d\- ]{7,10}$/i',
        message: 'Неверный формат телефона'
    )]
    public ?string $phoneNumber = null;
}