<?php

namespace App\Service\Action\Classes;

use App\Entity\Quest;
use App\Entity\Review;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\CreateReviewDto;
use App\Service\Dto\Classes\UpdateReviewDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quest.review.update', public: true)]
class UpdateReview extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.review.update')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var UpdateReviewDto $dto */
        $dto = $this->getDto();
        if ($dto->reviewId && $this->user->getId()) {
            $review = $this->doctrine->getRepository(Review::class)->find($dto->reviewId);
            if ($review) {
                try {
                    $review->setText($dto->text);
                    $review->setRating($dto->rating);
                    $em = $this->doctrine->getManager();
                    $em->persist($review);
                    $em->flush();
                    $this->responseService->addMessage('Отзыв обновлен');
                } catch (\Exception $exception) {
                    $this->responseService->addError('Ошибка сохранения отзыва');
                }
            } else {
                $this->responseService->addError('Не найден отзыв');
            }
        } else {
            $this->responseService->addError('Не передан ID отзыва');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}