<?php

namespace App\Service\Action\Classes;

use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\ChangePasswordDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.reset.password.change', public: true)]
class ResetPassword extends UserBaseActionService
{
    public function __construct(
        private UserPasswordHasherInterface $passwordHasher,
    )
    {
    }

    #[Required] public function initDto(
        #[Autowire(service: 'dto.password.change')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }


    public function runAction(): void
    {
        /** @var ChangePasswordDto $dto */
        $dto = $this->getDto();

        if ($this->passwordHasher->isPasswordValid($this->user, $dto->oldPassword)) {
            $hashedPassword = $this->passwordHasher->hashPassword(
                $this->user,
                $dto->password ?: ''
            );
            $this->user->setPassword($hashedPassword);

            try {
                $em = $this->doctrine->getManager();
                $em->persist($this->user);
                $em->flush();
                $this->responseService->addMessage('Пароль изменен');
            } catch (\Exception $exception) {
                $this->responseService->addError('Ошибка изменения пароля');
            }
        } else {
            $this->responseService->addError('Текущий пароль неверен');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}