<?php

namespace App\Service\Action\Classes;

use App\Entity\User;
use App\Service\Action\BaseActionService;
use App\Service\Dto\Classes\RecoveryDto;
use App\Service\Dto\DtoServiceInterface;
use App\Service\Send\SendServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.recovery.send', public: true)]
class RecoveryProfile extends BaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.recovery.send')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    #[Required] public function initSend(
        #[Autowire(service: 'send.code.recovery')]
        SendServiceInterface $sendService
    ): void
    {
        parent::initSend($sendService);
    }


    /**
     * Отправка кода восстановления учетной записи
     *
     * @return void
     */
    public function runAction(): void
    {
        /** @var RecoveryDto $dto */
        $dto = $this->getDto();
        /** @var User $userExists */
        $userExists = $this->doctrine->getRepository(User::class)
            ->findOneByUniq($dto->email, $dto->phoneNumber);

        if ($userExists !== null) {
            if (!$userExists->isDeleted()) {
                $this->responseService->addError('Профиль не удален');
            } else {
                $this->sendService->setUser($userExists);
                $this->sendService->setResponse($this->responseService);
                $this->sendService->send();
            }
        } else {
            $this->responseService->addError('Пользователь не найден');
        }
    }

    public function needDto(): bool
    {
        return true;
    }
}