<?php

namespace App\Service\Action\Classes;

use App\Entity\Like;
use App\Entity\Review;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quest.review.like', public: true)]
class LikeReview extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.id')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var IdDto $dto */
        $dto = $this->getDto();
        if ($dto->id) {
            $review = $this->doctrine->getRepository(Review::class)->find($dto->id);
            if ($review) {
                $likes = $review->getLikes();
                $exists = null;
                foreach ($likes as $like) {
                    if ($like->getRelatedUser() === $this->user) {
                        $exists = $like;
                    }
                }
                if ($exists) {
                    $this->responseService->addError('Вы уже оценили отзыв');
                } elseif ($review->getRelatedUser() === $this->user) {
                    $this->responseService->addError('Нельзя оценить свой отзыв');
                } else {
                    try {
                        $newLike = new Like();
                        $newLike->setRelatedUser($this->user);
                        $newLike->setReview($review);
                        $em = $this->doctrine->getManager();
                        $em->persist($newLike);
                        $em->flush();
                        $this->responseService->addMessage('Вам нравится отзыв');
                    } catch (\Exception $exception) {
                        $this->responseService->addError('Ошибка оценки отзыва');
                    }
                }
            } else {
                $this->responseService->addError('Не найден отзыв');
            }
        } else {
            $this->responseService->addError('Не получен ID отзыва');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}