<?php

namespace App\Service\Action\Classes;

use App\Service\Action\UserBaseActionService;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.profile', public: true)]
class GetProfile extends UserBaseActionService
{
    #[Required]
    public function initResponse(
        #[Autowire(service: 'response.profile')]
        ResponseServiceInterface $responseService
    ): void
    {
        parent::initResponse($responseService);
    }

    /**
     * Получение профиля пользователя
     *
     * @return void
     *
     * @throws \JsonException
     */
    public function runAction(): void
    {
        $this->responseService->setData($this->user);
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }

    public function needDto(): bool
    {
        return false;
    }
}