<?php

namespace App\Service\Action\Classes;

use App\Redis\Redis;
use App\Redis\RedisFilter;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\FilterDto;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.filter.get', public: true)]
class GetFilter extends UserBaseActionService
{
    #[Required] public function initResponse(
        #[Autowire(service: 'response.filter')]
        ResponseServiceInterface $responseService
    ): void
    {
        parent::initResponse($responseService);
    }

    public function runAction(): void
    {
        if ($this->user->getId()) {
            $redisFilter = new RedisFilter($this->user->getId());
            $filter = $redisFilter->get();
            if ($filter instanceof FilterDto) {
                $this->responseService->setData($filter);
            } else {
                $this->responseService->addError('Неверный формат фильтра');
            }
        } else {
            $this->responseService->addError('Пользователь не сохранен');
        }
    }

    public function needDto(): bool
    {
        return false;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}