<?php

namespace App\Service\Action\Classes;

use App\Entity\Review;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quest.review.delete', public: true)]
class DeleteReview extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.id')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var IdDto $dto */
        $dto = $this->getDto();
        if ($dto->id) {
            $review = $this->doctrine->getRepository(Review::class)->find($dto->id);
            if ($review) {
                try {
                    $em = $this->doctrine->getManager();
                    $em->remove($review);
                    $em->flush();
                    $this->responseService->addMessage('Отзыв удален');
                } catch (\Exception $exception) {
                    $this->responseService->addError('Ошибка удаления отзыва');
                }
            } else {
                $this->responseService->addError('Не найден отзыв');
            }
        } else {
            $this->responseService->addError('Не получен ID отзыва');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}