<?php

namespace App\Service\Action\Classes;

use App\Entity\UserHistory;
use App\Service\Action\UserBaseActionService;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;

#[AsAlias(id: 'action.profile.image.delete', public: true)]
class DeleteImage extends UserBaseActionService
{
    public function runAction(): void
    {
        $image = $this->user->getImage();
        if ($image) {
            $em = $this->doctrine->getManager();

            try {
                $newUserHistory = new UserHistory();
                $newUserHistory->setType(UserHistory::TYPE_DELETE);
                $newUserHistory->setField('image');
                $newUserHistory->setValue($image->getName());
                $this->user->addUserHistory($newUserHistory);
                $em->remove($image);
                $em->flush();
                $this->responseService->addMessage('Изображение удалено');
            } catch (\Exception $exception) {
                $this->responseService->addError('Ошибка удаления изображения');
            }
        } else {
            $this->responseService->addError('Нет изображения');
        }
    }

    public function needDto(): bool
    {
        return false;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}