<?php

namespace App\Service\Send;

use App\Messenger\Message\SendMessage;
use Symfony\Component\Messenger\MessageBusInterface;
use Throwable;

class SendService
{
    public ?string $from = null;
    public ?string $to = null;
    public ?string $subject = null;
    public ?string $body = null;

    public function __construct(
        private string $confirmType,
        private string $fromEmail,
        private readonly MessageBusInterface $bus
    )
    {
    }

    public function getFrom(): ?string
    {
        return $this->from;
    }

    public function setFrom(?string $from): self
    {
        $this->from = $from;

        return $this;
    }

    public function getTo(): ?string
    {
        return $this->to;
    }

    public function setTo(?string $to): self
    {
        $this->to = $to;

        return $this;
    }

    public function getSubject(): ?string
    {
        return $this->subject;
    }

    public function setSubject(?string $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getBody(): ?string
    {
        return $this->body;
    }

    public function setBody(?string $body): self
    {
        $this->body = $body;

        return $this;
    }

    public function send(): void
    {
        try {
            $this->bus->dispatch(new SendMessage(
                $this->from ?: $this->fromEmail,
                $this->to,
                $this->subject,
                $this->body,
                $this->confirmType
            ));
        } catch (Throwable $e) {
        }
    }
}