<?php

namespace App\Service\Send\Classes\Code;

use App\Service\Send\Classes\CodeSendService;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;

#[AsAlias(id: 'send.code.register', public: true)]
class RegisterCodeSendService extends CodeSendService
{
    public function getSubject(): string
    {
        return 'Подтвердите регистрацию';
    }

    public function getBody(): string
    {
        return <<<HTML
                    <div>Уважаемый {surname} {name} {patronymic}</div>
                    <div>Ваш код для подтверждения: {code}</div>
                    <div>Время действия кода: {time}</div>
                HTML;
    }
}