<?php

namespace App\Service\Action;

use App\Entity\User;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Contracts\Service\Attribute\Required;

abstract class UserBaseActionService extends BaseActionService
{
    protected ?User $user;

    #[Required]
    public function initUser(Security $security): void
    {
        $this->user = $security->getUser();
    }

    abstract public function checkDelete(): bool;

    abstract public function checkConfirm(): bool;

    public function customValidate(): bool
    {
        if ($this->user === null) {
            $this->responseService->addError('Вы не авторизованы');
            return false;
        }

        if ($this->checkDelete() && $this->user->isDeleted()) {
            $this->responseService->addError('Профиль удален');
            return false;
        }

        if ($this->checkConfirm() && !$this->user->isConfirm()) {
            $this->responseService->addError('Профиль не подтвержден');
            return false;
        }

        return true;
    }
}