<?php

namespace App\Service\Action\Classes;

use App\Entity\Quest;
use App\Service\Action\UserBaseActionService;
use App\Service\Dto\Classes\IdDto;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.quest.unsubscribe', public: true)]
class UnsubscribeQuest extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.id')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }

    public function runAction(): void
    {
        /** @var IdDto $dto */
        $dto = $this->getDto();
        if ($dto->id && $this->user->getId()) {
            $quest = $this->doctrine->getRepository(Quest::class)->findOneById($dto->id, $this->user->getId());
            if ($quest) {
                if (new \DateTime() > $quest->getFinalDate()) {
                    $this->responseService->addError('Время записи на квест окончено, отписаться нельзя');
                } else {
                    $appointments = $quest->getAppointments();
                    $exists = null;
                    foreach ($appointments as $appointment) {
                        if ($appointment->getRelatedUser() === $this->user) {
                            $exists = $appointment;
                        }
                    }
                    if ($exists) {
                        try {
                            $em = $this->doctrine->getManager();
                            $em->remove($exists);
                            $em->flush();
                            $this->responseService->addMessage('Вы отписаны от квеста');
                        } catch (\Exception $exception) {
                            $this->responseService->addError('Ошибка отписки от квеста');
                        }
                    } else {
                        $this->responseService->addError('Вы не подписаны на квест');
                    }
                }
            } else {
                $this->responseService->addError('Квест не найден');
            }
        } else {
            $this->responseService->addError('Не получен Id');
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return true;
    }
}