<?php

namespace App\Service\Action\Classes;

use App\Entity\Genre;
use App\Entity\Tag;
use App\Entity\Theme;
use App\Service\Action\BaseActionService;
use App\Service\Response\Classes\Data\Filter;
use App\Service\Response\ResponseServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.filter.params', public: true)]
class GetFilterParams extends BaseActionService
{
    #[Required] public function initResponse(
        #[Autowire(service: 'response.filter.params')]
        ResponseServiceInterface $responseService
    ): void
    {
        parent::initResponse($responseService);
    }

    public function runAction(): void
    {
        $filter = new Filter();

        $filter->themes = $this->doctrine->getRepository(Theme::class)->findAll();

        $filter->genres = $this->doctrine->getRepository(Genre::class)->findAll();

        $filter->tags = $this->doctrine->getRepository(Tag::class)->findAll();

        $this->responseService->setData($filter);
    }

    public function needDto(): bool
    {
        return false;
    }
}