<?php

namespace App\Service\Action\Classes;

use App\Service\Action\UserBaseActionService;
use App\Service\Dto\DtoServiceInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Contracts\Service\Attribute\Required;

#[AsAlias(id: 'action.register.code', public: true)]
class CheckRegisterCode extends UserBaseActionService
{
    #[Required] public function initDto(
        #[Autowire(service: 'dto.register.code')]
        DtoServiceInterface $dtoService
    ): void
    {
        parent::initDto($dtoService);
    }


    /**
     * Подтверждение регистрации по коду
     *
     * @return void
     */
    public function runAction(): void
    {
        $currentDate = new \DateTime();
        $code = $this->getDto()->code;
        $registerCode = $this->user->getRegisterCode();
        if ($registerCode === null) {
            $this->responseService->addError('Код подтверждения не отправлен');
        } else {
            if ($registerCodeDate = $registerCode->getDate()) {
                if ($registerCode->getCode() === $code && $currentDate->getTimestamp() < $registerCodeDate->getTimestamp()) {
                    try {
                        $this->user->setConfirm(true);
                        $em = $this->doctrine->getManager();
                        $em->persist($this->user);
                        $em->remove($registerCode);
                        $em->flush();
                        $this->responseService->addMessage('Регистрация подтверждена');
                    } catch (\Exception $exception) {
                        $this->responseService->addError('Ошибка подтверждения регистрации');
                    }
                } else {
                    $this->responseService->addError('Код недействителен');
                }
            } else {
                $this->responseService->addError('Код недействителен');
            }
        }
    }

    public function needDto(): bool
    {
        return true;
    }

    public function checkDelete(): bool
    {
        return true;
    }

    public function checkConfirm(): bool
    {
        return false;
    }
}