<?php

namespace App\Messenger\Handler;

use App\Entity\Quest;
use App\Messenger\Message\QuestMessage;
use App\Messenger\Objects\QuestsStart;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Messenger\MessageBusInterface;

#[AsMessageHandler]
class QuestStartMessageHandler
{
    public function __construct(
        protected MessageBusInterface $bus,
        private ManagerRegistry       $doctrine,
        private string $fromEmail,
    )
    {
    }

    /**
     * Обработка письма из очереди
     *
     * @param QuestsStart $message
     *
     * @return void
     */
    public function __invoke(QuestsStart $message): void
    {
        $quests = $this->doctrine->getRepository(Quest::class)->getStartQuests();

        foreach ($quests as $quest) {
            $appointments = $quest->getAppointments();
            $questName = $quest->getName();
            foreach ($appointments as $appointment) {
                $user = $appointment->getRelatedUser();
                if ($user) {
                    $userName = $user->getFullName();
                    $questMessage = new QuestMessage(
                        $this->fromEmail,
                        $user->getEmail(),
                        "Квест \"{$questName}\" стартует уже через 3 дня!",
                        <<<HTML
                        <div>
                            Здравствуйте, {$userName}!
                        </div>
                        <div>
                            Квест "{$questName}" стартует уже через 3 дня!
                        </div>
                        <div>
                            Чтобы не забыть, запланируйте его у себя в календаре!
                        </div>
                        HTML
                    );
                    $this->bus->dispatch($questMessage);
                }
            }
        }
    }
}