<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use App\Validators\PasswordValidator;
use App\Validators\UserValidator;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Validator\Constraints as Assert;

#[Assert\Callback([UserValidator::class, 'validateEmailOrPhone'])]
#[Assert\Callback([PasswordValidator::class, 'validateRepeatPassword'])]
#[Assert\Callback([PasswordValidator::class, 'validatePassword'])]
#[AsAlias(id: 'dto.password.code', public: true)]
class ResetPasswordCodeDto extends BaseDto
{
    #[Assert\Email(
        message: 'Email "{{ value }}" неверный.',
    )]
    public ?string $email = null;

    #[Assert\Regex(
        pattern: '/^((8|\+7)[\- ]?)?(\(?\d{3}\)?[\- ]?)?[\d\- ]{7,10}$/i',
        message: 'Неверный формат телефона'
    )]
    public ?string $phoneNumber = null;

    #[Assert\NotBlank(
        message: 'Не получен код подтверждения.',
    )]
    #[Assert\Regex(
        pattern: '/^\d{6}$/i',
        message: 'Неверный формат кода'
    )]
    public ?string $code = null;

    #[Assert\NotBlank(
        message: 'Не получен новый пароль.',
    )]
    public ?string $password = null;

    #[Assert\NotBlank(
        message: 'Не получен повтор нового пароля.',
    )]
    public ?string $repeatPassword = null;
}