<?php

namespace App\Service\Dto\Classes;

use App\Service\Dto\BaseDto;
use App\Validators\PasswordValidator;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\Validator\Constraints as Assert;

#[Assert\Callback([PasswordValidator::class, 'validateRepeatPassword'])]
#[Assert\Callback([PasswordValidator::class, 'validatePassword'])]
#[AsAlias(id: 'dto.register', public: true)]
class RegisterDto extends BaseDto
{
    #[Assert\NotBlank(
        message: 'Не получен Email.',
    )]
    #[Assert\Email(
        message: 'Email "{{ value }}" неверный.',
    )]
    public ?string $email = null;

    #[Assert\NotBlank(
        message: 'Не получен пароль.',
    )]
    public ?string $password = null;

    #[Assert\NotBlank(
        message: 'Не получен повтор пароля.',
    )]
    public ?string $repeatPassword = null;

    #[Assert\NotBlank(
        message: 'Не получено имя.',
    )]
    public ?string $name = null;

    #[Assert\NotBlank(
        message: 'Не получена фамилия.',
    )]
    public ?string $surname = null;

    public ?string $patronymic = null;

    #[Assert\Regex(
        pattern: '/^((8|\+7)[\- ]?)?(\(?\d{3}\)?[\- ]?)?[\d\- ]{7,10}$/i',
        message: 'Неверный формат телефона'
    )]
    public ?string $phoneNumber = null;
}