import type { TThemeColor } from '@interfaces/common';

export const convert100ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#9ca3af';
    case 'blue':
      return '#dbeafe';
    case 'sky':
      return '#e0f2fe';
    case 'cyan':
      return '#cffafe';
    case 'teal':
      return '#ccfbf1';
    case 'lime':
      return '#ecfccb';
    case 'green':
      return '#dcfce7';
    case 'yellow':
      return '#fef9c3';
    case 'amber':
      return '#fef3c7';
    case 'orange':
      return '#ffedd5';
    case 'pink':
      return '#fce7f3';
    case 'fuchsia':
      return '#fae8ff';
    case 'purple':
      return '#f3e8ff';
    case 'indigo':
      return '#e0e7ff';
    case 'rose':
      return '#ffe4e6';
    case 'red':
      return '#fee2e2';
    case 'black':
      return '#4b5563';
  }
};

export const convert200ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#d1d5db';
    case 'blue':
      return '#bfdbfe';
    case 'sky':
      return '#bae6fd';
    case 'cyan':
      return '#a5f3fc';
    case 'teal':
      return '#99f6e4';
    case 'lime':
      return '#d9f99d';
    case 'green':
      return '#bbf7d0';
    case 'yellow':
      return '#fef08a';
    case 'amber':
      return '#fde68a';
    case 'orange':
      return '#fed7aa';
    case 'pink':
      return '#fbcfe8';
    case 'fuchsia':
      return '#f5d0fe';
    case 'purple':
      return '#e9d5ff';
    case 'indigo':
      return '#c7d2fe';
    case 'rose':
      return '#fecdd3';
    case 'red':
      return '#fecaca';
    case 'black':
      return '#374151';
  }
};

export const convert300ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#e5e7eb';
    case 'blue':
      return '#93c5fd';
    case 'sky':
      return '#7dd3fc';
    case 'cyan':
      return '#67e8f9';
    case 'teal':
      return '#5eead4';
    case 'lime':
      return '#bef264';
    case 'green':
      return '#86efac';
    case 'yellow':
      return '#fde047';
    case 'amber':
      return '#fcd34d';
    case 'orange':
      return '#fdba74';
    case 'pink':
      return '#ec4899';
    case 'fuchsia':
      return '#f0abfc';
    case 'purple':
      return '#d8b4fe';
    case 'indigo':
      return '#a5b4fc';
    case 'rose':
      return '#fda4af';
    case 'red':
      return '#fca5a5';
    case 'black':
      return '#1f2937';
  }
};

export const convert400ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#f3f4f6';
    case 'blue':
      return '#60a5fa';
    case 'sky':
      return '#38bdf8';
    case 'cyan':
      return '#22d3ee';
    case 'teal':
      return '#2dd4bf';
    case 'lime':
      return '#a3e635';
    case 'green':
      return '#4ade80';
    case 'yellow':
      return '#facc15';
    case 'amber':
      return '#fbbf24';
    case 'orange':
      return '#fb923c';
    case 'pink':
      return '#f472b6';
    case 'fuchsia':
      return '#e879f9';
    case 'purple':
      return '#c084fc';
    case 'indigo':
      return '#818cf8';
    case 'rose':
      return '#fb7185';
    case 'red':
      return '#f87171';
    case 'black':
      return '#111827';
  }
};

export const convert500ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#ffffff';
    case 'blue':
      return '#3b82f6';
    case 'sky':
      return '#0ea5e9';
    case 'cyan':
      return '#06b6d4';
    case 'teal':
      return '#14b8a6';
    case 'lime':
      return '#84cc16';
    case 'green':
      return '#22c55e';
    case 'yellow':
      return '#eab308';
    case 'amber':
      return '#f59e0b';
    case 'orange':
      return '#f97316';
    case 'pink':
      return '#ec4899';
    case 'fuchsia':
      return '#d946ef';
    case 'purple':
      return '#a855f7';
    case 'indigo':
      return '#6366f1';
    case 'rose':
      return '#f43f5e';
    case 'red':
      return '#ef4444';
    case 'black':
      return '#000000';
  }
};

export const convert600ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#f3f4f6';
    case 'blue':
      return '#2563eb';
    case 'sky':
      return '#0284c7';
    case 'cyan':
      return '#0891b2';
    case 'teal':
      return '#0d9488';
    case 'lime':
      return '#65a30d';
    case 'green':
      return '#16a34a';
    case 'yellow':
      return '#ca8a04';
    case 'amber':
      return '#d97706';
    case 'orange':
      return '#ea580c';
    case 'pink':
      return '#db2777';
    case 'fuchsia':
      return '#c026d3';
    case 'purple':
      return '#9333ea';
    case 'indigo':
      return '#4f46e5';
    case 'rose':
      return '#e11d48';
    case 'red':
      return '#dc2626';
    case 'black':
      return '#111827';
  }
};

export const convert700ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#e5e7eb';
    case 'blue':
      return '#1d4ed8';
    case 'sky':
      return '#0369a1';
    case 'cyan':
      return '#0e7490';
    case 'teal':
      return '#0f766e';
    case 'lime':
      return '#4d7c0f';
    case 'green':
      return '#15803d';
    case 'yellow':
      return '#a16207';
    case 'amber':
      return '#b45309';
    case 'orange':
      return '#c2410c';
    case 'pink':
      return '#be185d';
    case 'fuchsia':
      return '#a21caf';
    case 'purple':
      return '#7e22ce';
    case 'indigo':
      return '#4338ca';
    case 'rose':
      return '#be123c';
    case 'red':
      return '#b91c1c';
    case 'black':
      return '#1f2937';
  }
};

export const convert800ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#d1d5db';
    case 'blue':
      return '#1e40af';
    case 'sky':
      return '#075985';
    case 'cyan':
      return '#155e75';
    case 'teal':
      return '#115e59';
    case 'lime':
      return '#3f6212';
    case 'green':
      return '#166534';
    case 'yellow':
      return '#854d0e';
    case 'amber':
      return '#92400e';
    case 'orange':
      return '#9a3412';
    case 'pink':
      return '#9d174d';
    case 'fuchsia':
      return '#86198f';
    case 'purple':
      return '#6b21a8';
    case 'indigo':
      return '#3730a3';
    case 'rose':
      return '#9f1239';
    case 'red':
      return '#991b1b';
    case 'black':
      return '#374151';
  }
};

export const convert900ThemeToColor = (theme: TThemeColor) => {
  switch (theme) {
    case 'white':
      return '#9ca3af';
    case 'blue':
      return '#1e3a8a';
    case 'sky':
      return '#0c4a6e';
    case 'cyan':
      return '#164e63';
    case 'teal':
      return '#134e4a';
    case 'lime':
      return '#365314';
    case 'green':
      return '#14532d';
    case 'yellow':
      return '#713f12';
    case 'amber':
      return '#78350f';
    case 'orange':
      return '#7c2d12';
    case 'pink':
      return '#831843';
    case 'fuchsia':
      return '#701a75';
    case 'purple':
      return '#581c87';
    case 'indigo':
      return '#312e81';
    case 'rose':
      return '#881337';
    case 'red':
      return '#7f1d1d';
    case 'black':
      return '#4b5563';
  }
};
