import React from 'react';
import { Inter } from 'next/font/google';

import './globals.css';
import StyledComponentsRegistry from './lib/registry';

import type { Metadata } from 'next';


const inter = Inter({ subsets: ['latin'] });

const RootLayout = ({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) => (
  <html lang="en">
    <body className={ inter.className }>
      <StyledComponentsRegistry>{ children }</StyledComponentsRegistry>
    </body>
  </html>
  );

  export const metadata: Metadata = {
    title: 'Create Next App',
    description: 'Generated by create next app',
  };

  export default RootLayout;
