<?php

    require_once __DIR__ . '/vendor/autoload.php';

    use Hp\Test\Functions;

    $func = new Functions();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
</head>
<body>
    <h1>Function 1</h1>
    <?php
        $array = [
            ['price'=>10, 'count'=>2],
            ['price'=>5, 'count'=>5],
            ['price'=>8, 'count'=>5],
            ['price'=>12, 'count'=>4],
            ['price'=>8, 'count'=>4],
        ];
        print_r($func->sortPrice($array));
    ?>

    <h1>Function 2</h1>
    <?php
        $array = [
            ['id'=>10, 'name'=>'Jhon', 'age'=>23],
            ['id'=>32, 'name'=>'Alex', 'age'=>34],
            ['id'=>54, 'name'=>'Bob', 'age'=>45],
            ['id'=>6, 'name'=>'Mike', 'age'=>61],
        ];
        print_r($func->search($array, 54));
    ?>


    <h1>Function 3</h1>
    <?php
        $arr = [
            ['laravel', 'php'],
            ['codeigniter', 'php'],
            ['laravel', 'php'],
            ['c++', 'java'],
        ];
        print_r($func->uniqElements($arr));
    ?>


    <h1>Function 4</h1>
    <?php
        $aMenu = [
            ['name' => 'Смартфоны и гаджеты','depth' => 0,],
            ['name' => 'Смартфоны, мобильные телефоны','depth' => 1,],
            ['name' => 'Планшеты','depth' => 1,],
            ['name' => 'Наушники и гарнитуры','depth' => 1,],
            ['name' => 'Компьютеры и ноутбуки','depth' => 0,],
            ['name' => 'Ноутбуки и аксессуары','depth' => 1,],
            ['name' => 'Компьютеры и мониторы','depth' => 1,],
            ['name' => 'Компьютерные комплектующие','depth' => 1,],
            ['name' => 'Техника для дома','depth' => 0,],
            ['name' => 'Техника для уборки','depth' => 1,],
            ['name' => 'Товары для ухода за одеждой','depth' => 1,],
            ['name' => 'Аксессуары для техники','depth' => 1,],
            ['name' => 'Товары для дома и кухни','depth' => 0,],
            ['name' => 'Посуда','depth' => 1,],
        ];
        print_r($func->prepareMenu($aMenu));
    ?>
    
    
    <h1>Function 5</h1>
    <?php
        print "<h2>До НГ: </h2>";
        try {
            print $func->howDaysToNy(new DateTimeImmutable());
        } catch (Exception $e) {
            print $e->getMessage();
        }
    ?>

    <h1>Function 6</h1>
    <?php
        print "<h2>Пятницы 13: </h2>";
        try {
            foreach ($func->countFriday13(2024) as $date) {
                print $date->format("Y-m-d l") . "\n";
            }
        } catch (Exception $e) {
            print $e->getMessage();
        }
    ?>


    <h1>Function 7</h1>
    <?php
        print "<h2>Разница дней: </h2>";
        print $func->diffDays(new DateTimeImmutable(), new DateTimeImmutable("2025-01-01"));
    ?>


    <h1>Function 8</h1>
    <?php
        try {
            $func->readLogFile(__DIR__ . "/public/text.txt");
        } catch (Exception $e) {
            print $e->getMessage();
        }
    ?>


    <h1>Function 9</h1>
    <?php
        try {
            foreach($func->readFileLineByLine(__DIR__ . "/public/text.txt") as $line) {
                print $line;
            }
        } catch (Exception $e) {
            print $e->getMessage();
        }
    ?>
</body>
</html>