<?php

declare(strict_types=1);

namespace Hp\Test;

class Functions
{
    /**
    * Выполняет сортировку массива по убыванию цены
    * @param array $array
    * @return array
    */

    public function sortPrice(array $array): array
    {
        $prices = array_column($array, 'price');
        $counts = array_column($array, 'count');
        array_multisort(
            $prices,
            SORT_DESC,
            $counts,
            SORT_ASC, $array
        );
        return $array;
    }

    /**
     * На выход должна вернуть отсортированный массив по ключу *price* DESC
     * и во вторую очередь по *count* ASC:
     * [['price'=>12, 'count'=>4],  ['price'=>10, 'count'=>2],  ['price'=>8, 'count'=>4],
     * ['price'=>8, 'count'=>5],  ['price'=>5, 'count'=>5],]
     */
}