<?php

namespace Hp\Patterns\Strategy;

class DifferentialPayment implements Payment
{
    public function calculate(float $total, float $balanceDebt, int $monthCount, float $percentOfRate): float
    {
        $payment = $total / $monthCount;

        $percentInMonth = $percentOfRate / 12 / 100;

        $payment += $balanceDebt * $percentInMonth;

        return $payment;
    }
}
