<?php

namespace Hp\Patterns\Strategy;

class AnnuityPayment implements Payment
{

    public function calculate(float $total, float $balanceDebt, int $monthCount, float $percentOfRate): float
    {
        $percentInMonth = $percentOfRate / 12 / 100;

        $payment = $total * ($percentInMonth + ($percentInMonth / ((1 + $percentInMonth)**$monthCount - 1)));

        $payment += $balanceDebt * $percentInMonth;

        return $payment;
    }
}