<?php

namespace Hp\Patterns\Iterator;

use Countable;
use Iterator;

class PaymentList implements Countable, Iterator
{
    /** @var array Payment */
    private array $payments;

    private int $currentIndex = 0;

    public function addPayment(Payment $payment): void
    {
        $this->payments[] = $payment;
    }

    public function removePayment(Payment $payment): void
    {
        foreach ($this->payments as $key => $value) {
            if ($value->getId() === $payment->getId()) {
                unset($this->payments[$key]);
            }
        }

        $this->payments = array_values($this->payments);
    }

    public function current(): Payment
    {
        return $this->payments[$this->currentIndex];
    }

    public function next(): void
    {
        $this->currentIndex++;
    }

    public function key(): int
    {
        return $this->currentIndex;
    }

    public function valid(): bool
    {
        return isset($this->payments[$this->currentIndex]);
    }

    public function rewind(): void
    {
        $this->currentIndex = 0;
    }

    public function count(): int
    {
        return count($this->payments);
    }
}