<?php

namespace Hp\Patterns\Builder;

class AccountBuilder implements Builder
{
    private string $accountType;

    private float $balance;

    private float $monthlyFee;

    public function withAccountType(string $accountType): Builder
    {
        $this->accountType = $accountType;

        return $this;
    }

    public function withInitialBalance(float $initialBalance): Builder
    {
        $this->balance += $initialBalance;

        return $this;
    }

    public function withMonthlyFee(float $monthlyFee): Builder
    {
        $this->monthlyFee = $monthlyFee;

        return $this;
    }
}