<?php

namespace Hp\Patterns\Adapter;

class AccountAdapter implements AccountInterface
{
    public function __construct(private OtherAccountInterface $account)
    {
    }


    public function deposit(float $amount): void
    {
        $this->account->deposit($amount);
    }

    public function withdraw(float $amount): void
    {
        $this->account->withdraw($amount);
    }

    public function blockAccount(): void
    {
        $this->account->blockAccount();
    }
}