<?php

namespace App\Service;

use App\Exception\RestaurantExceptionEnum;
use Exception;
use App\Mapper\RestaurantMapper;
use App\Model\RestaurantDetailElement;
use App\Model\RestaurantList;
use App\Repository\Interface\KitchenRepositoryInterface;
use App\Repository\Interface\RestaurantRepositoryInterface;
use App\Repository\Interface\RestaurantTypeRepositoryInterface;

class RestaurantService
{
    public function __construct(
        private RestaurantRepositoryInterface $restaurantRepository,
        private RestaurantTypeRepositoryInterface $restaurantTypeRepository,
        private KitchenRepositoryInterface $kitchenRepository,
    ) {}

    public function getRestaurants(
        $page,
        $limit,
        $restaurantTypeId,
        $kitchenId): RestaurantList
    {
        $restaurants = $this->restaurantRepository->getAll(
            $page,
            $limit,
            $restaurantTypeId,
            $kitchenId);
        $count = $this->restaurantRepository->getCount();
        $restaurantTypes = $this->restaurantTypeRepository->getAll();
        $kitchens = $this->kitchenRepository->getAll();
        return RestaurantMapper::mapToRestaurantList(
            $restaurants,
            $restaurantTypes,
            $kitchens,
            $page,
            $limit,
            $count
        );
    }

    public function getRestaurant(int $id): RestaurantDetailElement
    {
        $restaurant = $this->restaurantRepository->getById($id);
        if ($restaurant == null) {
            throw new Exception("Restaurant not found", RestaurantExceptionEnum::NotFound->value);
        }
        return RestaurantMapper::mapToDetailElement($restaurant);
    }
}